/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshaftsCommon;
import com.yungnickyoung.minecraft.bettermineshafts.module.StructureTypeModule;
import com.yungnickyoung.minecraft.bettermineshafts.world.config.BetterMineshaftConfiguration;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.BetterMineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class BetterMineshaftStructure
extends Structure {
    public static final MapCodec<BetterMineshaftStructure> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BetterMineshaftStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)BetterMineshaftConfiguration.CODEC.fieldOf("config").forGetter(structure -> structure.config)).apply((Applicative)builder, BetterMineshaftStructure::new));
    private final BetterMineshaftConfiguration config;

    public BetterMineshaftStructure(Structure.StructureSettings settings, BetterMineshaftConfiguration config) {
        super(settings);
        this.config = config;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        context.random().nextDouble();
        ChunkPos chunkPos = context.chunkPos();
        int y = context.random().nextInt(BetterMineshaftsCommon.CONFIG.maxY - BetterMineshaftsCommon.CONFIG.minY + 1) + BetterMineshaftsCommon.CONFIG.minY;
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(chunkPos.getBlockX(3), y, chunkPos.getBlockZ(3));
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        this.generatePieces(structurePiecesBuilder, context);
        return Optional.of(new Structure.GenerationStub((BlockPos)startingPos, Either.right((Object)structurePiecesBuilder)));
    }

    public StructureType<?> type() {
        return StructureTypeModule.BETTER_MINESHAFT;
    }

    private void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection((RandomSource)rand);
        int y = context.random().nextInt(BetterMineshaftsCommon.CONFIG.maxY - BetterMineshaftsCommon.CONFIG.minY + 1) + BetterMineshaftsCommon.CONFIG.minY;
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(context.chunkPos().getBlockX(3), y, context.chunkPos().getBlockZ(3));
        VerticalEntrance entryPoint = new VerticalEntrance(-1, startingPos, direction, this.config, context.heightAccessor().getMaxBuildHeight());
        structurePiecesBuilder.addPiece((StructurePiece)entryPoint);
        ((BetterMineshaftPiece)entryPoint).addChildren(entryPoint, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.random());
    }
}

